<?php

// Disallow direct access to this file for security reasons
if (!defined("IN_MYBB")) {
	die("Direct access to this file is not allowed.");
}

// Define hooks
$plugins->add_hook('showthread_end', 'include_javascript');
$plugins->add_hook('parse_message_start', 'get_code_blocks');
$plugins->add_hook('parse_message_end', 'add_select_all_link');

function code_select_all_info() {
	return array (
		"name"			=> "هاك تحديد الكود البرمجي",
		"description"	=> "يقوم باضافة امكانية نسخ كامل للكود البرمجي",
		"website"		=> "",
		"author"		=> "Brian McCloskey",
		"authorsite"	=> "",
		"version"		=> "1.0.0",
		"guid"			=> "29dce7d317b9893561eea8c03a520e5e",
		"compatibility"	=> "16*",
	);
}

function code_select_all_activate() {
	require_once(MYBB_ROOT."inc/adminfunctions_templates.php");
	
	find_replace_templatesets('showthread', "#".preg_quote('</head>')."#", '{$code_select_all_js}</head>');
}

function code_select_all_deactivate() {
	require_once(MYBB_ROOT."inc/adminfunctions_templates.php");
	
	find_replace_templatesets('showthread', "#".preg_quote('{$code_select_all_js}')."#", '');
}

function include_javascript() {
	global $mybb, $code_select_all_js;
	
	$url = "{$mybb->settings['bburl']}/jscripts/codeselect.js";
	$code_select_all_js = "<script type=\"text/javascript\" src=\"".$url."\"></script>";
}

function get_code_blocks($message) {
	global $stored_code;
	
	preg_match_all("#\[(code|php)\](.*?)\[/\\1\](\r\n?|\n?)#si", $message, $stored_code, PREG_SET_ORDER);
	
	return $message;
}

function add_select_all_link($message) {
	global $lang, $stored_code;

	if(count($stored_code) > 0) 
	{
		foreach($stored_code as $text)
		{
			//die($message);
			$id = uniqid();
			$message = preg_replace('#dir="ltr"><code>#', "dir=\"ltr\"><code id=\"$id\">", $message, 1);
			$message = preg_replace("#".$lang->code."<br />#", $lang->code."<a href=\"javascript:\" onclick=\"SelectAll('".$id."')\" class=\"select_all\"> اختيار الكل</a><br />", $message, 1);
		}
	}
	
	return $message;
}

?>